---
cwlVersion: "v1.2"
class: "CommandLineTool"
requirements:
- class: "DockerRequirement"
  dockerPull: "appsysbiohkijena/jipipe:6.0.0"
- class: "InitialWorkDirRequirement"
  listing:
  - entryname: "$(inputs.project.basename)"
    entry: "$(inputs.project)"
  - entryname: "inputs"
    entry: "$(inputs.inputs_dir)"
- class: "EnvVarRequirement"
  envDef:
    JAVA_TOOL_OPTIONS: "-Duser.home=/tmp -Djava.util.prefs.userRoot=/tmp/.java"
    XDG_CACHE_HOME: "/tmp/.cache"
    XDG_CONFIG_HOME: "/tmp/.config"
    XDG_DATA_HOME: "/tmp/.local/share"
baseCommand:
- "jipipe"
- "run"
inputs:
  project:
    type: "File"
    doc: "Exported JIPipe project (.jip) with relative paths into ./inputs"
  inputs_dir:
    type: "Directory"
    doc: "All staged input files and directories"
  output_dir:
    type: "string"
    default: "output/auto"
    inputBinding:
      prefix: "--output-folder"
    doc: "Single enforced export directory"
  user_directories_config:
    type: "string"
    default: "project-user-paths.json"
    inputBinding:
      prefix: "--overwrite-user-paths"
    doc: "Configuration to override user paths"
arguments:
- prefix: "--project"
  valueFrom: "$(inputs.project.basename)"
outputs:
  results:
    type: "Directory"
    outputBinding:
      glob: "outputs"
